# 帳票設計書 6-Log Output

## 概要

本ドキュメントは、VS Codeの出力パネル（Output Channel）でログを表示・保存する機能の帳票出力仕様を定義するものである。

### 本帳票の処理概要

Log Output機能は、VS Code内の各種ログ（拡張機能ログ、言語サーバーログ、Gitログ等）を出力パネルに表示し、ファイルとして保存する機能である。

**業務上の目的・背景**：開発者やトラブルシューティング担当者がVS Codeおよび拡張機能の動作状況を確認するために使用される。問題発生時のデバッグ、拡張機能開発時のログ確認、サポートチームへの情報提供等に活用される。

**帳票の利用シーン**：
- 出力パネルでのリアルタイム表示
- 「Output: Save Output」コマンドでのログファイル保存
- ログレベルのフィルタリングと表示

**主要な出力内容**：
1. タイムスタンプ
2. ログレベル（trace, debug, info, warning, error）
3. ログメッセージ
4. 出力元（チャネル名）

**帳票の出力タイミング**：
- リアルタイム：各ログ出力時に即時表示
- 保存：ユーザーが明示的に保存コマンドを実行した際

**帳票の利用者**：VS Codeユーザー、拡張機能開発者、サポートエンジニア

## 帳票種別

ログ出力 / 診断レポート

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | Output Panel | workbench.panel.output | リアルタイム表示 |
| - | Output Panel | workbench.panel.output | Output: Save Output コマンド |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | ログファイル (.log) |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | `{channelName}.log` |
| 出力方法 | ファイルダイアログ経由 |
| 文字コード | UTF-8 |

### MIME Type

| タイプ | 説明 |
|-------|------|
| OUTPUT_MIME | 通常出力 |
| LOG_MIME | ログ出力（構造化） |

### URI Scheme

| 項目 | 内容 |
|-----|------|
| スキーム | `output` (Schemas.outputChannel) |
| パス | チャネルID |

## 帳票レイアウト

### レイアウト概要

ログエントリは行単位のテキスト形式で出力される。

```
[2026-01-27T10:30:00.123Z] [info] [Extension Host] Extension 'vscode.typescript-language-features' activated.
[2026-01-27T10:30:00.456Z] [debug] [Git] git status --porcelain
[2026-01-27T10:30:01.789Z] [error] [Extension Host] Error in extension: Cannot find module
```

### ログエントリ構造

| No | 項目名 | 説明 | データ型 | 表示形式 |
|----|-------|------|---------|---------|
| 1 | timestamp | 発生時刻 | Date | ISO 8601形式 |
| 2 | level | ログレベル | LogLevel | [trace/debug/info/warning/error] |
| 3 | source | 出力元 | string | [チャネル名] |
| 4 | message | メッセージ本文 | string | プレーンテキスト |

### LogLevel enum

| 値 | 名前 | 説明 |
|----|------|------|
| 0 | Off | ログ無効 |
| 1 | Trace | トレースレベル |
| 2 | Debug | デバッグレベル |
| 3 | Info | 情報レベル |
| 4 | Warning | 警告レベル |
| 5 | Error | エラーレベル |

### チャネル種別

| 種別 | 説明 |
|------|------|
| DelegatedOutputChannelModel | 通常の出力チャネル |
| FileOutputChannelModel | ファイルベースの出力チャネル |
| MultiFileOutputChannelModel | 複数ファイルソースの出力チャネル |

## 出力条件

### フィルタリング条件

OutputViewFiltersによりログ表示を制御：

| フィルタ | デフォルト | 説明 |
|---------|----------|------|
| trace | true | traceレベル表示 |
| debug | true | debugレベル表示 |
| info | true | infoレベル表示 |
| warning | true | warningレベル表示 |
| error | true | errorレベル表示 |
| text | "" | テキストフィルタ（パターン） |
| categories | "" | カテゴリフィルタ |

### テキストフィルタ構文

| パターン | 説明 |
|---------|------|
| `pattern` | パターンを含む行を表示 |
| `!pattern` | パターンを含まない行を表示（除外） |
| `"quoted pattern"` | 引用符で囲んだパターン |
| `pattern1, pattern2` | カンマ区切りで複数パターン |

### 改ページ条件

N/A（テキストファイル出力のため改ページなし）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A | メモリ内バッファを直接取得 | - |

### データ取得元

#### IOutputChannel

| 参照項目 | 帳票項目との対応 | 取得方法 | 備考 |
|---------|----------------|---------|------|
| model | ログエントリ | IOutputChannelModel | テキストモデル |
| getLogEntries() | 構造化ログ | IOutputChannelModel | ログエントリ配列 |
| outputChannelDescriptor | チャネル情報 | OutputChannel | メタデータ |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| N/A | データ表示のみ | - | 計算なし |

## 処理フロー

### ログ表示フロー

```mermaid
flowchart TD
    A[拡張機能/サービスからログ出力] --> B[IOutputChannel.append]
    B --> C[OutputChannelModel.append]
    C --> D[ITextModel.pushEditOperations]
    D --> E{アクティブチャネル?}
    E -->|Yes| F[OutputViewPaneに表示]
    E -->|No| G[バッファに蓄積]
    F --> H{フィルタ条件}
    H -->|マッチ| I[行を表示]
    H -->|不一致| J[行を非表示]
```

### ログ保存フロー

```mermaid
flowchart TD
    A[Save Outputコマンド] --> B[OutputService.saveOutputAs]
    B --> C{複数チャネル?}
    C -->|Yes| D[registerCompoundLogChannel]
    C -->|No| E[単一チャネル取得]
    D --> F[getChannel]
    E --> F
    F --> G[fileDialogService.showSaveDialog]
    G --> H{ユーザー選択}
    H -->|キャンセル| I[処理終了]
    H -->|保存先選択| J[textModelService.createModelReference]
    J --> K[model.getValue]
    K --> L[fileService.writeFile]
    L --> M[完了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| チャネル未登録 | 存在しないチャネルID | "Channel '{id}' is not registered yet" | 正しいチャネルを指定 |
| ファイル選択キャンセル | ダイアログでキャンセル | (処理中断) | - |
| 書き込みエラー | ファイル保存失敗 | ファイルシステムエラー | 保存先を変更 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数千〜数万行 |
| 目標表示時間 | リアルタイム（50ms以内） |
| 目標保存時間 | 2秒以内 |

## セキュリティ考慮事項

- ログには機密情報（パス、トークン等）が含まれる可能性
- テレメトリログは専用チャネル（telemetryLogId）で管理
- ログレベル変更権限は制限される場合あり（canSetLogLevel）
- 保存ファイルはローカルに保持され外部送信は行わない

## 備考

- 出力チャネルはRegistry.as<IOutputChannelRegistry>で管理される
- アクティブチャネルはStorageService(OUTPUT_ACTIVE_CHANNEL_KEY)に保持
- ログレベルはILoggerServiceで管理・変更可能
- Word WrapはOutput設定で制御可能

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

出力チャネルのデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | output.ts | `src/vs/workbench/services/output/common/output.ts` | IOutputChannel, IOutputChannelDescriptor interface |
| 1-2 | log.ts | `src/vs/platform/log/common/log.ts` | LogLevel enum |

**読解のコツ**: IOutputChannelがチャネルの基本インターフェース。

#### Step 2: サービス実装を理解する

出力サービスの実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | outputServices.ts | `src/vs/workbench/contrib/output/browser/outputServices.ts` | OutputService class (行302-630) |
| 2-2 | outputServices.ts | `src/vs/workbench/contrib/output/browser/outputServices.ts` | OutputChannel class (行36-88) |
| 2-3 | outputServices.ts | `src/vs/workbench/contrib/output/browser/outputServices.ts` | OutputViewFilters class (行100-300) |

**主要処理フロー**:
- **行302-396**: OutputService constructor - サービス初期化
- **行406-416**: showChannel() - チャネル表示
- **行492-537**: saveOutputAs() - ログ保存

#### Step 3: フィルタリング機能を理解する

ログフィルタリングの仕組みを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | outputServices.ts | `src/vs/workbench/contrib/output/browser/outputServices.ts` | OutputViewFilters (行100-300) |

**主要処理フロー**:
- **行137-148**: text setter - フィルタテキスト設定
- **行149-174**: parseText() - パターン解析
- **行184-219**: splitByCommaRespectingQuotes() - パターン分割
- **行221-299**: 各ログレベルフィルタのgetter/setter

### プログラム呼び出し階層図

```
拡張機能/サービス
    │
    └─ vscode.window.createOutputChannel()
           │
           └─ OutputService.createChannel()
                  │
                  ├─ OutputChannel.new()
                  │      │
                  │      └─ createOutputChannelModel()
                  │             │
                  │             ├─ DelegatedOutputChannelModel
                  │             ├─ FileOutputChannelModel
                  │             └─ MultiFileOutputChannelModel
                  │
                  └─ channels.set(id, channel)

ログ出力
    │
    └─ IOutputChannel.append()
           │
           └─ model.append()
                  │
                  └─ textModel.pushEditOperations()

ログ保存
    │
    └─ OutputService.saveOutputAs()
           │
           ├─ showSaveDialog()
           │
           ├─ textModelService.createModelReference()
           │
           └─ fileService.writeFile()
```

### データフロー図

```
[入力]                    [処理]                           [出力]

拡張機能ログ          ┌─────────────────────┐
                     │                     │
  ─────────────────▶│    OutputService    │
                     │                     │
言語サーバーログ     │ - createChannel()   │──────▶ Output Panel
  ─────────────────▶│ - showChannel()     │        (リアルタイム表示)
                     │ - saveOutputAs()    │
Gitログ等           │                     │
  ─────────────────▶│                     │──────▶ {name}.log
                     │                     │        (ファイル保存)
                     └─────────────────────┘
                            │
                            ▼
                    OutputViewFilters
                     (フィルタリング)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| outputServices.ts | `src/vs/workbench/contrib/output/browser/outputServices.ts` | ソース | サービス実装 |
| output.ts | `src/vs/workbench/services/output/common/output.ts` | ソース | インターフェース定義 |
| outputChannelModel.ts | `src/vs/workbench/contrib/output/common/outputChannelModel.ts` | ソース | チャネルモデル |
| outputView.ts | `src/vs/workbench/contrib/output/browser/outputView.ts` | ソース | 出力ビュー |
| outputLinkProvider.ts | `src/vs/workbench/contrib/output/browser/outputLinkProvider.ts` | ソース | リンク検出 |
| log.ts | `src/vs/platform/log/common/log.ts` | ソース | ログレベル定義 |
